<?php

// =============================== Flickr widget ======================================

class Woo_flickr extends WP_Widget {

   function Woo_flickr() {
	   $widget_ops = array('description' => 'This Flickr widget populates photos from a Flickr ID.' );
       parent::WP_Widget(false, __('Woo - Flickr', 'woothemes'),$widget_ops);      
   }
   

   function widget($args, $instance) {  
    extract( $args );
   	$id = $instance['id'];
    $number = $instance['number'];

      
	 echo $before_widget;

     echo $before_title; ?>
     <?php _e('Photos on <span>flick<span>r</span></span>','woothemes'); ?>
     <?php echo $after_title; ?>
            
                <div class="fix"></div>
                <script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count=<?php echo $number; ?>&amp;display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user=<?php echo $id; ?>"></script>        
                <div class="fix"></div>

   <?php
			
   echo $after_widget;
   
   }

   function update($new_instance, $old_instance) {                
       return $new_instance;
   }

   function form($instance) {        
   
       $id = esc_attr($instance['id']);
       $number = esc_attr($instance['number']);
	   
       ?>
        <p>
            <label for="<?php echo $this->get_field_id('id'); ?>"><?php _e('Flickr ID (<a href="http://www.idgettr.com">idGettr</a>):','woothemes'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('id'); ?>" value="<?php echo $id; ?>" class="widefat" id="<?php echo $this->get_field_id('id'); ?>" />

        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of Images:','woothemes'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('number'); ?>" value="<?php echo $number; ?>" class="widefat" id="<?php echo $this->get_field_id('number'); ?>" />

        </p>

      <?php
   }

} 

register_widget('woo_flickr');



// =============================== Search widget ======================================
class Woo_search extends WP_Widget {

   function Woo_search() {
	   $widget_ops = array('description' => 'This is a WooThemes standardized search widget.' );
       parent::WP_Widget(false, __('Woo - Search', 'woothemes'),$widget_ops);      
   }
   

   function widget($args, $instance) {  
    extract( $args );
   	$title = $instance['title'];
    $display = $instance['display'];
	?>
      
	 <?php echo $before_widget; ?>

     <?php if ($display == 'on') { echo $before_title . $title . $after_title; } ?>
     
     <?php include(TEMPLATEPATH . '/search-form.php'); ?>
     
			
   <?php echo $after_widget; ?>
   
   <?php
   }

   function update($new_instance, $old_instance) {                
       return $new_instance;
   }

   function form($instance) {        
   
       $title = esc_attr($instance['title']);
       $display = esc_attr($instance['display']);

	   
       ?>
       
       <p>
	   	   <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','woothemes'); ?></label>
	       <input type="input" name="<?php echo $this->get_field_name('title'); ?>"  value="<?php echo $title; ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />

       </p>
       
       <p>
	   	   <label for="<?php echo $this->get_field_id('display'); ?>"><?php _e('Display Title:','woothemes'); ?></label>
	       <input type="checkbox" name="<?php echo $this->get_field_name('display'); ?>"  value="on" <?php if($display == 'on'){echo 'checked="checked"';} ?> class="" id="<?php echo $this->get_field_id('display'); ?>" />

       </p>

      <?php
   }

} 

register_widget('Woo_search');


// =============================== BS News CATEGORY Loop Widget ======================================

class BS_CatLoop extends WP_Widget {

   function BS_CatLoop() {
	   $widget_ops = array('description' => 'This widget is used for populating posts from a category. (NEWS)' );
       parent::WP_Widget(false, __('Woo Category Widget (News)', 'woothemes'),$widget_ops);      
   }
   

   function widget($args, $instance) {  
    extract( $args );
   	$title = $instance['title'];
    $cat_id = $instance['cat_id'];
    $num = $instance['num'];
	$content = $instance['content'];
    $pag = $instance['pag'];
    $width = $instance['width'];
    $height = $instance['height'];
    $meta = $instance['meta'];
	$thumbs = $instance['thumbs'];


     global $query_string;
	 if($pag == 'on'){
    	 query_posts($query_string . "&cat=$cat_id&showposts=$num");
	 }else{
	 	query_posts("cat=$cat_id&showposts=$num");
	 }
      
	 echo $before_widget; ?>

     <?php echo $before_title . $title . $after_title; ?>
     
            <?php if (have_posts()) : $count = 0; ?>
            <?php while (have_posts()) : the_post(); $count++; ?>
                                                                        
                <!-- Post Starts -->
                <div class="post wrap">
					<?php if($thumbs != 'on') woo_get_image('image',$width,$height,'widget-post-thumbnail',90,get_the_id()); ?>
                    <h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
                    <?php if($meta != 'on'){?>
                    <p class="post-details"><?php _e('Posted on','woothemes') ?> <?php the_time('d. M, Y'); ?> by  <?php the_author_posts_link(); ?> in <?php the_category(', ') ?></p>
                    <?php } ?>
                    
                    <?php
					   if($content == "excerpt") { the_excerpt(); }
                       elseif($content == "content"){ the_content(); }
					?>
                </div>
                <!-- Post Ends -->
                
                <?php endwhile; else: ?>
                <p><?php _e('Sorry, no posts matched your criteria.','woothemes'); ?></p>
            <?php endif; ?>  
            <?php if($pag == 'on'){?>
             <div class="more_entries">
                <?php if (function_exists('wp_pagenavi')) wp_pagenavi(); else { ?>
                <div class="alignleft"><?php previous_posts_link(__('&laquo; Newer Entries ','woothemes')) ?></div>
                <div class="alignright"><?php next_posts_link(__(' Older Entries &raquo;','woothemes')) ?></div>
                <br class="fix" />
            	<?php } ?> 
            </div>
            <?php
            } // Pagination On/off
			
   echo $after_widget;
   
   }

   function update($new_instance, $old_instance) {                
       return $new_instance;
   }

   function form($instance) {        
   
       $title = esc_attr($instance['title']);
       $cat_id = esc_attr($instance['cat_id']);
       $num = esc_attr($instance['num']);
       $pag = esc_attr($instance['pag']);
	   $width = esc_attr($instance['width']);
	   $height = esc_attr($instance['height']);
	   $meta = esc_attr($instance['meta']);
	   $content = esc_attr($instance['content']);
	   $thumbs = esc_attr($instance['thumbs']); 
	   
	   if(empty($title)){ $title = 'Category Widget';}
	   if(empty($width)){ $width = 80;}
	   if(empty($height)){ $height = 80;}
       ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','woothemes'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $title; ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />

        </p>
       	<p>
	   	   <label for="<?php echo $this->get_field_id('cat_id'); ?>"><?php _e('Category:','woothemes'); ?></label>
	       <?php $cats = get_categories(); ?>
	       <select name="<?php echo $this->get_field_name('cat_id'); ?>" class="widefat" id="<?php echo $this->get_field_id('cat_id'); ?>">
           <option value="">Disabled</option>
			<?php
			
           	foreach ($cats as $cat){
           	?><option value="<?php echo $cat->cat_ID; ?>" <?php if($cat_id == $cat->cat_ID){ echo "selected='selected'";} ?>><?php echo $cat->cat_name . ' (' . $cat->category_count . ')'; ?></option><?php
           	}
           ?>
           </select>
       </p>
       <p>
	   	   <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('Number of Posts:','woothemes'); ?></label>
	       <input type="text" name="<?php echo $this->get_field_name('num'); ?>" value="<?php echo $num; ?>" class="widefat" id="<?php echo $this->get_field_id('num'); ?>" />

       </p>
       <p>
          <label for="<?php echo $this->get_field_id('content'); ?>"><?php _e('Show Content:','woothemes'); ?></label>
          <select name="<?php echo $this->get_field_name('content'); ?>" class="widefat" id="<?php echo $this->get_field_id('content'); ?>">
           <option value="off" <?php if($content == "off"){ echo "selected='selected'";} ?>>Off</option> 
           <option value="content" <?php if($content == "content"){ echo "selected='selected'";} ?>>The Content</option> 
           <option value="excerpt" <?php if($content == "excerpt"){ echo "selected='selected'";} ?>>The Excerpt</option>
           </select>
       </p> 
       
        <p>
            <label for="<?php echo $this->get_field_id('width'); ?>"><?php _e('Thumb Size:','woothemes'); ?></label>
            <input type="text" size="2" name="<?php echo $this->get_field_name('width'); ?>" value="<?php echo $width; ?>" class="" id="<?php echo $this->get_field_id('width'); ?>" /> W
            <input type="text" size="2" name="<?php echo $this->get_field_name('height'); ?>" value="<?php echo $height; ?>" class="" id="<?php echo $this->get_field_id('height'); ?>" /> H
        </p> 
       
       
       <p>
	   	   <label for="<?php echo $this->get_field_id('pag'); ?>"><?php _e('Pagination:','woothemes'); ?></label>
	       <input type="checkbox" name="<?php echo $this->get_field_name('pag'); ?>"  value="on" <?php if($pag == 'on'){echo 'checked="checked"';} ?> class="" id="<?php echo $this->get_field_id('pag'); ?>" /> <small>Home only</small>

       </p>
       <p>
	   	   <label for="<?php echo $this->get_field_id('meta'); ?>"><?php _e('Hide Post Meta:','woothemes'); ?></label>
	       <input type="checkbox" name="<?php echo $this->get_field_name('meta'); ?>"  value="on" <?php if($meta == 'on'){echo 'checked="checked"';} ?> class="" id="<?php echo $this->get_field_id('meta'); ?>" />

       </p>
       <p>
	   	   <label for="<?php echo $this->get_field_id('thumbs'); ?>"><?php _e('Hide Thumbnails:','woothemes'); ?></label>
	       <input type="checkbox" name="<?php echo $this->get_field_name('thumbs'); ?>"  value="on" <?php if($thumbs == 'on'){echo 'checked="checked"';} ?> class="" id="<?php echo $this->get_field_id('thumbs'); ?>" />

       </p>

      <?php
   }

} 

register_widget('BS_CatLoop');

// =============================== BS Media TAG Widget ======================================

class BS_MediaLoop extends WP_Widget {

   function BS_MediaLoop() {
	   $widget_ops = array('description' => 'This widget is used for populating posts from a Tag. (MEDIA)' );
       parent::WP_Widget(false, __('Woo Tag Widget (Tag)', 'woothemes'),$widget_ops);      
   }
   

   function widget($args, $instance) {  
    extract( $args);
   	$title = $instance['title'];
    $tag_name = $instance['tag_name'];
    $num = $instance['num'];
    $limit_pictures = $instance['limit_pictures'];
    $limit_players = $instance['limit_players'];
    $content = $instance['content'];

	$width = $instance['width'];
    $height = $instance['height'];
    $video_width = $instance['video_width'];
    $video_height = $instance['video_height'];
	$audio_width = $instance['audio_width'];
	
	$lightbox = $instance['lightbox'];
	
	

     //$tag_name = get_term_by('id', $tag_id, 'post_tag');
     //$string = "tag=" . $tag_name->name ."&showposts=$num";
	 $string = "tag=" . $tag_name ."&showposts=$num";
     $posts = get_posts($string);
     global $post;
	 
	 echo $before_widget;
     ?>
     
     <?php echo $before_title . $title . $after_title; ?>
     
     
            <?php if ($posts) : $count = 0; ?>
            <?php foreach ($posts as $post) : setup_postdata($post); $count++; ?>
                                                                        
                <!-- Post Starts -->
                <div class="post wrap">
                
                      	<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
                      	
                       <?php 
                       if($content == "excerpt") { the_excerpt(); }
                       elseif($content == "content"){ the_content(); }
                       
     
                         $instance = array(
					     	'post_id' => get_the_id(),
					      	'size' => 'thumb',
					      	'image_caption' => 'off',
					      	'image_title' => 'off',
                            'video_width' => $video_width,
                            'video_height' => $video_height,
                            'audio_width' => $audio_width,
                            'audio_height' => 19,
							'image_width' => $width,
                            'image_height' => $height,
							'widget_id' => $args['widget_id'],
							
							'limit_players' => $limit_players,
					      	'limit_pictures' => $limit_pictures,
							
							'lightbox' => $lightbox
					     	
					     );
                         woo_media_add($instance);
                         
                         ?>

                </div>
                <!-- Post Ends -->
                
                <?php endforeach; else: ?>
                <p><?php _e('Sorry, no posts matched your criteria.','woothemes'); ?></p>
            <?php endif; ?>  
            <?php if($pag == on){?>
             <div class="more_entries">
                <?php if (function_exists('wp_pagenavi')) wp_pagenavi(); else { ?>
                <div class="alignleft"><?php previous_posts_link(__('&laquo; Newer Entries ','woothemes')) ?></div>
                <div class="alignright"><?php next_posts_link(__(' Older Entries &raquo;','woothemes')) ?></div>
                <br class="fix" />
            	<?php } ?> 
            </div>
            <?php
            } // Pagination On/off
            
            $media_tag = get_option('woo_media_tag');
               
              if($media_tag){     
             ?>
             <div class="title_link">
				<p><?php _e('More','woothemes') ?> <a href="<?php echo get_term_link($media_tag,'post_tag'); ?>" title="<?php _e('Archive','woothemes');?>"><?php echo $media_tag; ?> &raquo;</a></p>
			</div>
			<?php
                }
	echo $after_widget;	
            
   }

   function update($new_instance, $old_instance) {                
       return $new_instance;
   }

   function form($instance) {        
       
	   $title = esc_attr($instance['title']);
       $tag_name = esc_attr($instance['tag_name']);
       $num = esc_attr($instance['num']);
       $limit_pictures = esc_attr($instance['limit_pictures']);
       $limit_players = esc_attr($instance['limit_players']);
       $content = esc_attr($instance['content']);
	   
	   $width = esc_attr($instance['width']); 
	   $height = esc_attr($instance['height']);
	   $video_width = esc_attr($instance['video_width']);
	   $video_height = esc_attr($instance['video_height']);
	   $audio_width = esc_attr($instance['audio_width']);
	   
	   $lightbox = esc_attr($instance['lightbox']);
	   
       
	   if(empty($title)){ $title = 'Tag Widget';}
       if(empty($limit_pictures)){ $limit_pictures = 6;}
       if(empty($limit_players)){ $limit_players = 2;}
	   
	   if(empty($width)){ $width = 70;}
	   if(empty($height)){ $height = 70;}
	   if(empty($video_width)){ $video_width = 220;}
	   if(empty($video_height)){ $video_height = 140;}
	   if(empty($audio_width)){ $audio_width = 200;}


       ?>
         <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','woothemes'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $title; ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />

       </p>
       	<p>
	   	   <label for="<?php echo $this->get_field_id('tag_name'); ?>"><?php _e('Media Tag:','woothemes'); ?></label>
	       <input type="text" name="<?php echo $this->get_field_name('tag_name'); ?>" value="<?php echo $tag_name; ?>" class="widefat" id="<?php echo $this->get_field_id('tag_name'); ?>" />

		   
		   <?php /* $tags = get_tags(); ?>
	        <select name="<?php echo $this->get_field_name('tag_id'); ?>" class="widefat" id="<?php echo $this->get_field_id('tag_id'); ?>">
           
            <option value="">-- Please Select --</option>
			<?php
			
           	foreach ($tags as $tag){
           	?><option value="<?php echo $tag->term_id; ?>" <?php if($tag_id == $tag->term_id){ echo "selected='selected'";} ?>><?php echo $tag->name . ' (' . $tag->count . ')'; ?></option><?php
           	}
           ?>
           </select> */ ?>
       </p>
       <p>
	   	   <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('Number of Posts:','woothemes'); ?></label>
	       <input type="text" name="<?php echo $this->get_field_name('num'); ?>" value="<?php echo $num; ?>" class="widefat" id="<?php echo $this->get_field_id('num'); ?>" />

       </p>
       <p>
            <label for="<?php echo $this->get_field_id('width'); ?>"><?php _e('Image Size:','woothemes'); ?></label>
            <input type="text" size="2" name="<?php echo $this->get_field_name('width'); ?>" value="<?php echo $width; ?>" class="" id="<?php echo $this->get_field_id('width'); ?>" /> W
            <input type="text" size="2" name="<?php echo $this->get_field_name('height'); ?>" value="<?php echo $height; ?>" class="" id="<?php echo $this->get_field_id('height'); ?>" /> H
       </p>
       <p>
            <label for="<?php echo $this->get_field_id('video_width'); ?>"><?php _e('Video Size:','woothemes'); ?></label>
            <input type="text" size="2" name="<?php echo $this->get_field_name('video_width'); ?>" value="<?php echo $video_width; ?>" class="" id="<?php echo $this->get_field_id('video_width'); ?>" /> W
            <input type="text" size="2" name="<?php echo $this->get_field_name('video_height'); ?>" value="<?php echo $video_height; ?>" class="" id="<?php echo $this->get_field_id('video_height'); ?>" /> H
       </p> 
       <p>
            <label for="<?php echo $this->get_field_id('audio_width'); ?>"><?php _e('Player Width:','woothemes'); ?></label>
            <input type="text" size="2" name="<?php echo $this->get_field_name('audio_width'); ?>" value="<?php echo $audio_width; ?>" class="" id="<?php echo $this->get_field_id('audio_width'); ?>" /> W
       </p> 
       <p>
            <label for="<?php echo $this->get_field_id('limit_pictures'); ?>"><?php _e('Limit pictures to','woothemes'); ?></label> 
            <input type="text" size="2" name="<?php echo $this->get_field_name('limit_pictures'); ?>" value="<?php echo $limit_pictures; ?>" class="" id="<?php echo $this->get_field_id('limit_pictures'); ?>" />

       </p>
       <p>	   	   <label for="<?php echo $this->get_field_id('limit_players'); ?>"><?php _e('Limit MP3 players to','woothemes'); ?></label> 
	       <input type="text" size="2" name="<?php echo $this->get_field_name('limit_players'); ?>" value="<?php echo $limit_players; ?>" class="" id="<?php echo $this->get_field_id('limit_players'); ?>" />

       </p> 
       <p>
          <label for="<?php echo $this->get_field_id('content'); ?>"><?php _e('Show Content:','woothemes'); ?></label>
          <select name="<?php echo $this->get_field_name('content'); ?>" class="widefat" id="<?php echo $this->get_field_id('content'); ?>">
           <option value="off" <?php if($content == "off"){ echo "selected='selected'";} ?>>Off</option> 
           <option value="content" <?php if($content == "content"){ echo "selected='selected'";} ?>>The Content</option> 
           <option value="excerpt" <?php if($content == "excerpt"){ echo "selected='selected'";} ?>>The Excerpt</option>
           </select>
       </p>
       <p>
	   	   <label for="<?php echo $this->get_field_id('lightbox'); ?>"><?php _e('Lightbox:','woothemes'); ?></label>
	       <input type="checkbox" name="<?php echo $this->get_field_name('lightbox'); ?>"  value="on" <?php if($lightbox == 'on'){echo 'checked="checked"';} ?> class="" id="<?php echo $this->get_field_id('lightbox'); ?>" />

       </p>

       

      <?php
   }

} 

register_widget('BS_MediaLoop');

// =============================== BS Alt Cat Widget ======================================

class BS_ShowsLoop extends WP_Widget {

   function BS_ShowsLoop() {
	   $widget_ops = array('description' => 'This widget is used for populating posts from a category, using an alternate style.' );
       parent::WP_Widget(false, __('Woo Alt Category Widget (Shows)', 'woothemes'),$widget_ops);      
   }
   

   function widget($args, $instance) {  
	
	extract( $args );
	$title = $instance['title'];
	$cat_id = $instance['cat_id'];
	$num = $instance['num'];
	$order = $instance['order'];
	$width = $instance['width'];
	$height = $instance['height'];
	$thumb = $instance['thumb'];
	
	
	
	if(empty($order)){ $order = 'ASC';}
	
	//echo 'This is Media Widget';
	$string = "cat=" . $cat_id ."&showposts=$num&order=$order";
	$posts = get_posts($string);
	global $post;
	echo $before_widget;	
	?>
    
    
    <?php echo $before_title . $title . $after_title; ?>
    
            <?php if (posts) : $count = 0; ?>
            <?php foreach ($posts as $post) : setup_postdata($post); $count++; ?>
                                                                        
                <!-- Post Starts -->
                <div class="post wrap">
                
                      	<div class="show">
							<?php if($thumb != 'on') woo_get_image('image',$width,$height,'widget-post-thumbnail',90,get_the_id()); ?>
							<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
							<?php the_excerpt(); ?>
							<div><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Find out more','woothemes') ?>"><?php _e('Read More','woothemes');?></a><?php if (get_post_meta($post->ID, "more_info", true)){ ?> | <a href="<?php echo get_post_meta($post->ID, "more_info", true); ?>"><?php _e('More Information','woothemes') ?></a><?php } ?></div>
						</div>  
						                 


                </div>
                <!-- Post Ends -->
                
                <?php endforeach; else: ?>
                <p><?php _e('Sorry, no posts matched your criteria.','woothemes') ?></p>
            <?php endif; ?>  
            <?php if($pag == on){?>
             <div class="more_entries">
                <?php if (function_exists('wp_pagenavi')) wp_pagenavi(); else { ?>
                <div class="alignleft"><?php previous_posts_link(__('&laquo; Newer Entries ','woothemes')) ?></div>
                <div class="alignright"><?php next_posts_link(__(' Older Entries &raquo;','woothemes')) ?></div>
                <br class="fix" />
            	<?php } ?> 
            </div>
            <?php
            } // Pagination On/off
			
			
			if(get_option('woo_shows_cat') != 'Select a category:'){
            ?>
            <div class="title_link">
				<p><?php _e('See full listings on','woothemes'); ?> <a href="<?php echo get_category_link(get_cat_id(get_option('woo_shows_cat'))); ?>" title="<?php _e('Archive','woothemes'); ?>"><?php _e('the shows page &raquo;','woothemes'); ?></a></p>
			</div>	
			<?php
			}
	echo $after_widget;	
   }

   function update($new_instance, $old_instance) {                
       return $new_instance;
   }

   function form($instance) {        
       
	   $title = esc_attr($instance['title']);
       $cat_id = esc_attr($instance['cat_id']);
       $num = esc_attr($instance['num']);
       //$pag = esc_attr($instance['pag']);
	   $order = esc_attr($instance['order']);
	   
	   $width = esc_attr($instance['width']); 
	   $height = esc_attr($instance['height']);

	   
	   if(empty($width)){ $width = 40;}
	   if(empty($height)){ $height = 40;}
	
	   
	   if(empty($title)){ $title = 'Alternate Category Widget';}

       ?>
         <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','woothemes'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $title; ?>" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" />

       </p>
       	<p>
	   	   <label for="<?php echo $this->get_field_id('cat_id'); ?>"><?php _e('Category:','woothemes'); ?></label>
	       <?php $cats = get_categories(); ?>
	       <select name="<?php echo $this->get_field_name('cat_id'); ?>" class="widefat" id="<?php echo $this->get_field_id('cat_id'); ?>">
           <option value="">Disabled</option>
			<?php
			
           	foreach ($cats as $cat){
           	?><option value="<?php echo $cat->cat_ID; ?>" <?php if($cat_id == $cat->cat_ID){ echo "selected='selected'";} ?>><?php echo $cat->cat_name . ' (' . $cat->category_count . ')'; ?></option><?php
           	}
           ?>
           </select>
       </p>
       <p>
	   	   <label for="<?php echo $this->get_field_id('num'); ?>"><?php _e('Number of Posts:','woothemes'); ?></label>
	       <input type="text" name="<?php echo $this->get_field_name('num'); ?>" value="<?php echo $num; ?>" class="widefat" id="<?php echo $this->get_field_id('num'); ?>" />

       </p>
       <p>
            <label for="<?php echo $this->get_field_id('width'); ?>"><?php _e('Thumb Size:','woothemes'); ?></label>
            <input type="text" size="2" name="<?php echo $this->get_field_name('width'); ?>" value="<?php echo $width; ?>" class="" id="<?php echo $this->get_field_id('width'); ?>" /> W
           <input type="text" size="2" name="<?php echo $this->get_field_name('height'); ?>" value="<?php echo $height; ?>" class="" id="<?php echo $this->get_field_id('height'); ?>" /> H
        </p> 
       <p>
	   	   <label for="<?php echo $this->get_field_id('order'); ?>"><?php _e('Order By:','woothemes'); ?></label>
	       <?php $cats = get_categories(); ?>
	       <select name="<?php echo $this->get_field_name('order'); ?>" class="widefat" id="<?php echo $this->get_field_id('order'); ?>">
               <option value="ASC" <?php if($order == 'ASC'){ echo "selected='selected'"; } ?>>ASC</option>
               <option value="DESC" <?php if($order == 'DESC'){ echo "selected='selected'"; } ?>>DESC</option>
           </select>
       </p>

   


      <?php
   }

} 

register_widget('BS_ShowsLoop');

// =============== Ad Space ===========

class Woo_AdWidget extends WP_Widget {

   function Woo_AdWidget() {
	   $widget_ops = array('description' => 'Use this widget to add any type of Ad as a widget.' );
       parent::WP_Widget(false, __('Woo - Adspace Widget', 'woothemes'),$widget_ops);      
   }
   

   function widget($args, $instance) {  
   
   	$adcode = $instance['adcode'];
    $image = $instance['image'];
    $href = $instance['href'];
	$alt = $instance['alt'];



	if($adcode != ''){
	?>
    <div class="adspace-widget"><?php echo $adcode; ?></div>
    
    <?php } else { ?>
    
    <div class="adspace-widget">
     <a href="<?php echo $href; ?>"><img src="<?php echo $image; ?>" alt="<?php echo $alt; ?>" /></a>
    </div>

    <?php
	}

   }

   function update($new_instance, $old_instance) {                
       return $new_instance;
   }

   function form($instance) {        
   
  
       $adcode = esc_attr($instance['adcode']);
       $image = esc_attr($instance['image']);
       $href = esc_attr($instance['href']);
       $alt = esc_attr($instance['alt']);
	   
	   ?>
	   
       
       <p>
            <label for="<?php echo $this->get_field_id('adcode'); ?>"><?php _e('Ad Code:','woothemes'); ?></label>
            <textarea name="<?php echo $this->get_field_name('adcode'); ?>" class="widefat" id="<?php echo $this->get_field_id('adcode'); ?>"><?php echo $adcode; ?></textarea>

        </p>
       
       <p><strong>or</strong>
       </p>
       
       
       <p>
            <label for="<?php echo $this->get_field_id('image'); ?>"><?php _e('Image Url:','woothemes'); ?></label>
            <input type="text" name="<?php echo $this->get_field_name('image'); ?>" value="<?php echo $image; ?>" class="widefat" id="<?php echo $this->get_field_id('image'); ?>" />

        </p>
       
       <p>
	   	   <label for="<?php echo $this->get_field_id('href'); ?>"><?php _e('Link URL:','woothemes'); ?></label>
	       <input type="text" name="<?php echo $this->get_field_name('href'); ?>" value="<?php echo $href; ?>" class="widefat" id="<?php echo $this->get_field_id('href'); ?>" />

       </p>
       <p>
	   	   <label for="<?php echo $this->get_field_id('alt'); ?>"><?php _e('Alt text:','woothemes'); ?></label>
	       <input type="text" name="<?php echo $this->get_field_name('alt'); ?>" value="<?php echo $alt; ?>" class="widefat" id="<?php echo $this->get_field_id('alt'); ?>" />

       </p>
       
       <?php
   }

} 

register_widget('Woo_AdWidget');






/* Deregister Default Widgets */

function woo_deregister_widgets(){
    unregister_widget('WP_Widget_Search');         
}
add_action('widgets_init', 'woo_deregister_widgets');  


?>